VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DLXOCX32.OCX"
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   4440
   ClientLeft      =   2595
   ClientTop       =   1770
   ClientWidth     =   6060
   LinkTopic       =   "Form1"
   ScaleHeight     =   4440
   ScaleWidth      =   6060
   Begin VB.Frame Frame1 
      Caption         =   "Waveform Type"
      Height          =   1215
      Left            =   3000
      TabIndex        =   5
      Top             =   840
      Width           =   2055
      Begin VB.OptionButton Option2 
         Caption         =   "Square Wave"
         Height          =   195
         Left            =   360
         TabIndex        =   7
         Top             =   780
         Width           =   1335
      End
      Begin VB.OptionButton optSine 
         Caption         =   "Sine Wave"
         Height          =   195
         Left            =   360
         TabIndex        =   6
         Top             =   360
         Value           =   -1  'True
         Width           =   1215
      End
   End
   Begin VB.CommandButton cmdStop 
      Caption         =   "Stop AO"
      Enabled         =   0   'False
      Height          =   375
      Left            =   840
      TabIndex        =   3
      Top             =   1920
      Width           =   1695
   End
   Begin VB.CommandButton cmdSample 
      Caption         =   "Start Continuous AO"
      Enabled         =   0   'False
      Height          =   375
      Left            =   840
      TabIndex        =   1
      Top             =   1320
      Width           =   1695
   End
   Begin VB.CommandButton cmdInit 
      Caption         =   "Initialize Device 0"
      Height          =   375
      Left            =   840
      TabIndex        =   0
      Top             =   720
      Width           =   1695
   End
   Begin DlsrLib.DriverLINXLDD LDD 
      Left            =   240
      Top             =   600
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin DlsrLib.DriverLINXSR SR 
      Left            =   240
      Top             =   1320
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Label Label3 
      Caption         =   $"frmMain.frx":0000
      Height          =   1215
      Left            =   3120
      TabIndex        =   8
      Top             =   2280
      Width           =   2655
   End
   Begin VB.Label Label2 
      BackColor       =   &H8000000E&
      Height          =   255
      Left            =   720
      TabIndex        =   4
      Top             =   2520
      Width           =   2055
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   " KEITHLEY "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H8000000E&
      Height          =   300
      Left            =   960
      TabIndex        =   2
      Top             =   120
      Width           =   1455
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit ' require variable declaration
' allocate array for the data and some other variables that will be needed
Const bufSize As Integer = 1000
Dim SineData() As Single
Dim SqWaveData() As Single
Dim dummy As Single
Dim i As Integer
'
'  This program demonstrates how to provide new data to
'  an Analog Output task as the task runs.
'
'  It was tested with a DAS-1801AO in Win98SE with DriverLINX version
'  DAS1800-850A01.0.0.4.  This example should be suitable for use also with
'  other boards which support paced mode AO such as:  KPCI-3108, KPCI-3116,
'  KPCI-3110, KPCI-180xHC, DDA-08/DDA-16.  Rates and use of DMA or Interrupt
'  mode may require adjusting for use with these other boards
'

Private Sub cmdInit_Click()
' open the driver and initialize the hardware
With SR
.Req_DLL_name = "kmb1800"  ' give driver name to avoid Open DriverLINX dialog
.Req_device = 0   ' device number from DLinx Config Panel
.Req_mode = DL_OTHER
.Req_op = DL_INITIALIZE
.Req_subsystem = DL_DEVICE
.Refresh
' error check
End With
' use of the LDD control is not required
If SR.Res_result = DL_NoErr Then
cmdSample.Enabled = True
LDD.Req_DLL_name = SR.Req_DLL_name
LDD.device = SR.Req_device
LDD.Refresh
Form1.Caption = "New AO Buffer Data 'On the Fly' with " & LDD.Dev_Model 'from the LDD, determine the model number
Else
SR.Req_op = DL_MESSAGEBOX
SR.Refresh
Form1.Caption = "Error in Opening Driver and Initializing the Hardware"
End If
' the LDD control can inform your application
' about the features of the hardware
Form1.SetFocus
End Sub

Private Sub cmdSample_Click()

SetupAOnonStop ' this allocates the data buffers and sets up Paced AO task
' now need to load the buffers with data
'
ReDim SineData(bufSize)  ' declare some local arrays for our waveforms
ReDim SqWaveData(bufSize)


' step 1, load arrays with voltage data for sine or square wave
For i = 0 To (bufSize - 1)
SineData(i) = 5 * Sin(2 * 3.142857 * i / (bufSize - 1))  ' 5 volts sine wave
SqWaveData(i) = (i And 1) * 2.5   ' 2.5 volts square wave
Next i


' next move the voltage arrays to the driver's memory buffers
Dim bufIndex As Integer
For bufIndex = 0 To SR.Sel_buf_N - 1  'load each buffer
    If optSine.Value = True Then
    dummy = SR.VBArrayBufferConvert(bufIndex, 0, bufSize, SineData, DL_tSINGLE, 0, 0)
    Else
    dummy = SR.VBArrayBufferConvert(bufIndex, 0, bufSize, SqWaveData, DL_tSINGLE, 0, 0)
    End If
Next bufIndex
' now start the task
SR.Refresh  ' start the task
' error check
SR.Req_op = DL_MESSAGEBOX
SR.Refresh
' see Private Sub SR_BufferFilled() for what happens next
If SR.Res_result = DL_NoErr Then
cmdStop.Enabled = True
cmdSample.Enabled = False
End If

End Sub

Private Sub cmdStop_Click()
With SR
.Req_op = DL_STOP
.Refresh
End With
If SR.Res_result = DL_NoErr Then
cmdStop.Enabled = False
cmdSample.Enabled = True
End If
End Sub

Private Sub Form_Terminate()
'call code to stop the task just in case it is still running
cmdStop_Click
' unload the driver for each object
SR.Req_DLL_name = ""
LDD.Req_DLL_name = ""
End Sub

Sub SetupAOnonStop()
With SR
' Request Group
.Req_op = DL_START
.Req_mode = DL_DMA
.Req_subsystem = DL_AO
' Event Group
.Evt_Str_type = DL_COMMAND  ' start when .Refresh is called
.Evt_Stp_type = DL_COMMAND  ' stop when Stop Operation is executed
' indeterminate sampling duration (stp on command or trigger) has
' impacts on buffering requirements
.Evt_Tim_type = DL_RATEEVENT ' timing will be used
.Evt_Tim_rateChannel = DL_DEFAULTTIMER  ' each board has default timing channel
.Evt_Tim_rateClock = DL_INTERNAL1       ' internal1 timebase
.Evt_Tim_rateGate = DL_NOCONNECT   ' no gating
.Evt_Tim_rateMode = DL_RATEGEN     ' two updates for each tic of clock
.Evt_Tim_rateOutput = CT_Output_Default ' not used for RATEGEN
.Evt_Tim_ratePeriod = .DLSecs2Tics(DL_DEFAULTTIMER, 1 / 5000)  'one buffer every 200msec
' Select Group
.Sel_chan_format = DL_tNATIVE  ' use the card's native format
.Sel_chan_N = 1                ' a start channel only
.Sel_chan_start = 0            ' start on channel 0
.Sel_chan_startGainCode = .DLGain2Code(-1) ' negative = bipolar, 1 = gain of 1
.Sel_chan_stop = 0
.Sel_chan_stopGainCode = .DLGain2Code(-1)
' allocate three buffers of bufSize samples each for the data
.Sel_buf_N = 5                 ' five buffers used
.Sel_buf_samples = bufSize
' when stop condition is command or trigger, must have minimum of 3 buffers
' and the total buffer size (sum of all buffers) should approximate at
' least 1 second worth of data.....5 buffers x 1000 samples/buffer = 5000 samples
' DAC update rate is 5000 Hz...we have 1 second worth of buffering
' the buffer size MUST be a multiple of how many channels are in the scan
.Sel_buf_notify = DL_NOTIFY  ' send buffer filled message
End With
End Sub

Private Sub SR_BufferFilled(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Integer)

Label2.Caption = "Finished writing buffer #: " & Str(bufIndex)

    If optSine.Value = True Then
    dummy = SR.VBArrayBufferConvert(bufIndex, 0, bufSize, SineData, DL_tSINGLE, 0, 0)
    Else
    dummy = SR.VBArrayBufferConvert(bufIndex, 0, bufSize, SqWaveData, DL_tSINGLE, 0, 0)
    End If

' provide new data to the AO buffers here so that
' values could be determined and written "on the fly"

' the BufferFilled message contains the bufIndex that has just been
' written to the DAC.  If we program new waveform type into this
' just completed buffer, we will not see the new data until that buffer
' is again written.  How long depends on how many total buffers and the
' DAC update rate (buffer consumption rate).

' for the sample rate, assign buffer size so that BufferFilled messages are not
' sent at a rate faster than is practical for Windows message queue processing,
' e.g., not faster than appx 10 msec rate
End Sub

Private Sub SR_DataLost(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Long, bufElement As Long)
' a Data Lost message could result if buffer size is too small for the
' the requested sample rate
'
MsgBox "Data Lost Message has Occured...try increasing size of or number of buffers", vbOKOnly
'
' could just restart the acquisition from here or take other corrective actions
'With SR
'.Req_op = DL_START
'.Refresh
'End With
End Sub
